// Waffle Code by Radnen //

// Create the square that must be completed in game //
// These squares are called a rubik's Waffle due to //
// Their special properties and actions. //

RequireScript("Button.js");
RequireSystemScript("time.js");

function Waffle(size, title)
{
	this.size = size;
	this.title = title;
	// Create game grid //
	this.grid = [size];
	this.clearGrid();
	// Clone it for mirroring //
	this.gridClone = [size];
	this.cloneGrid();
	// Create Buttons //
	this.xButtons = [];
	for (var i = 0; i < size; ++i) this.xButtons[i] = new Button(ButtonImage, ButtonOverImage);
	this.yButtons = [];
	for (var i = 0; i < size; ++i) this.yButtons[i] = new Button(ButtonImage, ButtonOverImage);	
	this.clearButton = new Button(BigButtonImage, BigButtonOverImage);
	// Create extra properties //
	this.width = this.size*16;
	this.height = this.size*16;
	this.preRender = function() {}
	this.postRender = function() {}
	this.marked = DarkGray;
	this.unmarked = White;
	this.moves = 0;
	this.minMoves = 0;
	// Create control properties //
	this.showMoveBox = true;
	this.canWin = true;
	this.showClearButton = false;
}

Waffle.prototype.display = function(x, y)
{
	var completed = false;
	var done = false;
	while(!IsKeyPressed(KEY_ESCAPE) && !done)
	{
		this.preRender();
		this.drawTitle();
		this.drawSquares(x, y);
		for (var i = 0; i < this.size; ++i)
		{
			if (Cursor.x > x && Cursor.x < x+16*this.size && Cursor.y > y-16 && Cursor.y < y && !completed)
			{
				if (Cursor.x > x+i*16 && Cursor.x < x+16+i*16)
				{
					if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
					{
						Cursor.leftIdle = false;
						this.moves++;
						this.rotateColumn(i);
						if (this.canWin) completed = this.checkField();
					}
				}
			} //*/
			if (Cursor.x > x-16 && Cursor.x < x && Cursor.y > y && Cursor.y < y+16*this.size && !completed)
			{
				if (Cursor.y > y+i*16 && Cursor.y < y+16+i*16)
				{
					if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
					{
						Cursor.leftIdle = false;
						this.moves++;
						this.rotateRow(i);
						if (this.canWin) completed = this.checkField();
					}
				}
			} //*/
		}
		if (this.showClearButton) this.drawClearButton();
		if (this.showMoveBox) this.drawMoveBox();
		if (completed)
		{
			this.drawSquares(x, y); // re-update the squares;
			this.postRender();
			var str = "You have completed the square!";
			window.drawWindow(SW/2-font.getStringWidth(str)/2, SH-48, font.getStringWidth(str), 8);
			font.drawText(SW/2-font.getStringWidth(str)/2, SH-50, str);
		}
		else this.postRender();
		FlipScreen();
		if (completed) { Delay(2000); done = true; }
	}
}

Waffle.prototype.drawSquares = function(x, y)
{
	for (var i = 0; i < this.size; ++i)
	{
		this.yButtons[i].blit(x-16, y + i*16); // left-side column
		this.xButtons[i].blit(x + i*16, y-16); // top row
		for (var j = 0; j < this.size; ++j)
		{
			if (this.grid[i][j] == 0) Rectangle(x + j*16, y + i*16, 16, 16, this.marked);
			else Rectangle(x + j*16, y + i*16, 16, 16, this.unmarked);
		}
	}
	OutlinedRectangle(SW/2-this.width/2, SH/2-this.height/2, this.width, this.height, Black, 1);
}

Waffle.prototype.rotateColumn = function(num)
{
	// Invert the numbers(colors) for the column //
	for (var i = 0; i < this.size; ++i)
	{
		for (var j = 0; j < num+1; ++j)
		{
			this.grid[i][j] = this.gridClone[this.size-1-i][j];
			if (this.grid[i][j] == 0) this.grid[i][j] = 1;
			else this.grid[i][j] = 0;
		}
	} //*/
	this.cloneGrid();
}

Waffle.prototype.rotateRow = function(num)
{
	// Invert the numbers(colors) for the row //
	for (var i = 0; i < num+1; ++i)
	{
		for (var j = 0; j < this.size; ++j)
		{
			this.grid[i][j] = this.gridClone[i][this.size-1-j];
			if (this.grid[i][j] == 0) this.grid[i][j] = 1;
			else this.grid[i][j] = 0;
		}
	} //*/
	this.cloneGrid();
}

Waffle.prototype.cloneGrid = function()
{
	for (var i = 0; i < this.size; ++i)
	{
		this.gridClone[i] = new Array();
		for (var j = 0; j < this.size; ++j) this.gridClone[i][j] = this.grid[i][j];
	}
}

Waffle.prototype.drawMoveBox = function()
{
	window.drawWindow(SW/2+this.width/2+12, SH/2-4, 64, 8);
	font.drawText(SW/2+this.width/2+12, SH/2-24, "Moves:");
	font.drawText(SW/2+this.width/2+12, SH/2-6, this.moves);
}

Waffle.prototype.drawClearButton = function()
{
	this.clearButton.blit(SW/2-32, SH/2+this.height/2+8);
	font.drawText(SW/2-font.getStringWidth("CLEAR")/2, SH/2+this.height/2+12, "CLEAR");
	if (Cursor.x > SW/2-32 && Cursor.y > SH/2+this.height/2+8 &&
			Cursor.x < SW/2+32 && Cursor.y < SH/2+this.height/2+32)
	{
		if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
		{
			Cursor.leftIdle = false;
			this.clearGrid();
			this.cloneGrid();
		}
	}
}

Waffle.prototype.drawTitle = function()
{
	window.drawWindow(8, 8, font.getStringWidth(this.title), 8);
	font.drawText(8, 6, this.title); 
}

// Will generate a random solvable field //
Waffle.prototype.generateField = function(moves)
{
	this.minMoves = moves;
	for (var i = 0; i < moves; ++i)
	{
		var move_type = Math.floor(Math.random()*2);
		if (move_type == 0) this.rotateRow(Math.floor(Math.random()*this.size));
		else this.rotateColumn(Math.floor(Math.random()*this.size));
	} //*/
}

// This is used on the clear button to clear the grid //
Waffle.prototype.clearGrid = function()
{
	for (var i = 0; i < this.size; ++i)
	{
		this.grid[i] = new Array();
		for (var j = 0; j < this.size; ++j) this.grid[i][j] = 1// Math.floor((Math.random()*2));
	}
}

// Will check the field and return true if totally white //
Waffle.prototype.checkField = function()
{
	for (var i = 0; i < this.size; ++i)
	{
		for (var j = 0; j < this.size; ++j)
		{
			// return false if any position in grid is black //
			if (this.grid[i][j] == 0) return false;
		}
	}
	// if it was all white, return true! //
	return true;
}

// This is used for the arcade mode. It condenses the levels into images.
Waffle.prototype.createImage = function()
{
	var surf = CreateSurface(40, 40, CreateColor(255, 255, 255));
	var wh = 40/this.size;
	for (var i = 0; i < this.size; ++i)
	{
		for (var j = 0; j < this.size; ++j)
		{
			if (this.grid[i][j] == 0) surf.rectangle(j*wh, i*wh, wh, wh, this.marked);
			else surf.rectangle(j*wh, i*wh, wh, wh, this.unmarked);
		}
	}
	surf.outlinedRectangle(0, 0, 40, 40, Black);
	return surf.createImage();
}